
<?php
// Criação do Custom Post Type
add_action('init', function() {
    register_post_type('cadastro_cliente', [
        'labels' => [
            'name' => 'Cadastro Clientes',
            'singular_name' => 'Cadastro Cliente'
        ],
        'public' => false,
        'show_ui' => true,
        'menu_icon' => 'dashicons-id',
        'supports' => ['title'],
        'capability_type' => 'post',
    ]);
});

// Adicionar metabox para visualizar os metadados
add_action('add_meta_boxes', function() {
    add_meta_box('cadastro_cliente_dados', 'Dados do Cliente', function($post) {
        $campos = ['cpf', 'cnpj', 'data_nascimento', 'cep', 'endereco', 'numero', 'complemento', 'bairro', 'cidade', 'estado'];
        echo '<table class="form-table">';
        foreach ($campos as $campo) {
            $valor = get_post_meta($post->ID, $campo, true);
            echo "<tr><th><label for='$campo'>" . ucfirst(str_replace('_', ' ', $campo)) . "</label></th><td><input type='text' id='$campo' name='$campo' value='" . esc_attr($valor) . "' class='regular-text' readonly></td></tr>";
        }
        $doc_frente = get_post_meta($post->ID, 'documento_frente', true);
        $doc_verso = get_post_meta($post->ID, 'documento_verso', true);
        if ($doc_frente) echo "<tr><th>Documento Frente</th><td><a href='" . esc_url($doc_frente) . "' target='_blank'>Ver arquivo</a></td></tr>";
        if ($doc_verso) echo "<tr><th>Documento Verso</th><td><a href='" . esc_url($doc_verso) . "' target='_blank'>Ver arquivo</a></td></tr>";
        echo '</table>';
    }, 'cadastro_cliente');
});
