
<?php
// Remover os uploads (frente e verso) quando o post for excluído definitivamente
add_action('before_delete_post', function($post_id) {
    if (get_post_type($post_id) !== 'cadastro_cliente') return;

    $frente = get_post_meta($post_id, 'documento_frente', true);
    $verso = get_post_meta($post_id, 'documento_verso', true);

    $attachments = get_posts([
        'post_type' => 'attachment',
        'posts_per_page' => -1,
        'post_status' => 'any',
        'meta_query' => [
            'relation' => 'OR',
            [
                'key' => '_wp_attached_file',
                'value' => basename($frente),
                'compare' => 'LIKE'
            ],
            [
                'key' => '_wp_attached_file',
                'value' => basename($verso),
                'compare' => 'LIKE'
            ]
        ]
    ]);

    foreach ($attachments as $attachment) {
        wp_delete_attachment($attachment->ID, true);
    }
});
