
<?php
// Adicionar submenu de exportação
add_action('admin_menu', function() {
    add_submenu_page('edit.php?post_type=cadastro_cliente', 'Exportar Contatos', 'Exportar Contatos', 'manage_options', 'exportar-contatos', 'render_exportar_contatos');
});

function render_exportar_contatos() {
    echo "<div class='wrap'><h1>Exportar Contatos</h1>";
    echo "<form method='post'><button type='submit' name='exportar_csv' class='button button-primary'>Exportar CSV</button></form></div>";
}

add_action('admin_init', function() {
    if (isset($_POST['exportar_csv'])) {
        $clientes = get_posts(['post_type' => 'cadastro_cliente', 'numberposts' => -1]);

        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename=contatos.csv');

        $output = fopen('php://output', 'w');
        fputcsv($output, ['Nome', 'E-mail', 'Telefone']);

        foreach ($clientes as $cliente) {
            fputcsv($output, [
                $cliente->post_title,
                get_post_meta($cliente->ID, 'email', true),
                get_post_meta($cliente->ID, 'telefone', true),
            ]);
        }

        fclose($output);
        exit;
    }
});
