<?php

// Redirecionar uploads para pasta personalizada
add_filter('upload_dir', function($dirs) {
    $custom_subdir = '/img_clientes';
    $dirs['path'] = $dirs['basedir'] . $custom_subdir;
    $dirs['url'] = $dirs['baseurl'] . $custom_subdir;
    $dirs['subdir'] = $custom_subdir;
    return $dirs;
});

?>

<?php
// Shortcode para o formulário
add_shortcode('cadastro_clientes_form', function() {
    ob_start();

    $mensagem_sucesso = '';
    $mensagem_erro = '';

    if (isset($_POST['cadastro_clientes_enviar'])) {
        $erros = [];

        // Validações obrigatórias
        if (empty($_POST['nome_completo'])) $erros[] = 'Nome completo';
        if (empty($_POST['cpf']) && empty($_POST['cnpj'])) $erros[] = 'CPF ou CNPJ';
        if (empty($_POST['data_nascimento'])) $erros[] = 'Data de nascimento';
        if (empty($_POST['cep'])) $erros[] = 'CEP';
        if (empty($_POST['endereco'])) $erros[] = 'Endereço';
        if (empty($_POST['numero'])) $erros[] = 'Número';
        if (empty($_POST['bairro'])) $erros[] = 'Bairro';
        if (empty($_POST['cidade'])) $erros[] = 'Cidade';
        if (empty($_POST['estado'])) $erros[] = 'Estado';
        if (empty($_POST['tomada_220v']) || count($_POST['tomada_220v']) !== 1) $erros[] = 'Tomada 220V (marcar apenas uma opção)';
        if (empty($_FILES['documento_frente']['name'])) $erros[] = 'Documento Frente';

        if (empty($erros)) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/media.php';
            require_once ABSPATH . 'wp-admin/includes/image.php';

            $post_id = wp_insert_post([
                'post_type' => 'cadastro_cliente',
                'post_title' => sanitize_text_field($_POST['nome_completo']),
                'post_status' => 'publish'
            ]);

            foreach ($_POST as $key => $value) {
                if ($key !== 'cadastro_clientes_enviar') {
                    update_post_meta($post_id, $key, is_array($value) ? implode(', ', $value) : sanitize_text_field($value));
                }
            }

            foreach (['documento_frente', 'documento_verso'] as $campo) {
                if (!empty($_FILES[$campo]['name'])) {
                    $attachment_id = media_handle_upload($campo, $post_id);
                    if (!is_wp_error($attachment_id)) {
                        $url = wp_get_attachment_url($attachment_id);
                        update_post_meta($post_id, $campo, esc_url_raw($url));
                    }
                }
            }

            $mensagem_sucesso = '<div class="cadastro-sucesso">Cadastro enviado com sucesso!</div>';
        } else {
            $mensagem_erro = '<div class="cadastro-erro">Por favor, preencha os seguintes campos obrigatórios:<br><strong>' . implode(', ', $erros) . '</strong></div>';
        }
    }

    ?>
    <style>
        .cadastro-form { max-width: 600px; margin: 20px auto; }
        .cadastro-form label { display: block; margin-top: 15px; font-weight: bold; }
        .cadastro-form input, .cadastro-form select { width: 100%; padding: 8px; margin-top: 5px; }
        .cadastro-form .row-group { display: flex; gap: 10px; }
        .cadastro-form .row-group > div { flex: 1; }
        .cadastro-form button { margin-top: 20px; padding: 10px 20px; }
        .cadastro-sucesso {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            padding: 12px;
            border-radius: 4px;
            margin-bottom: 20px;
            text-align: center;
        }
        .cadastro-erro {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
            padding: 12px;
            border-radius: 4px;
            margin-bottom: 20px;
            text-align: center;
        }
        .checkbox-inline { display: inline-block; margin-right: 15px; }
    </style>
    
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('input[name=cpf]').mask('000.000.000-00');
        $('input[name=cnpj]').mask('00.000.000/0000-00');
        $('input[name=cep]').mask('00000-000');

        $('input[name=cep]').on('blur', function() {
            var cep = $(this).val().replace(/\D/g, '');
            if (cep.length === 8) {
                $.getJSON('https://viacep.com.br/ws/' + cep + '/json/', function(data) {
                    if (!data.erro) {
                        $('input[name=endereco]').val(data.logradouro);
                        $('input[name=bairro]').val(data.bairro);
                        $('input[name=cidade]').val(data.localidade);
                        $('select[name=estado]').val(data.uf);
                    }
                });
            }
        });

        // Exclusividade de checkboxes tomada 220V
        $('input[name="tomada_220v[]"]').on('change', function() {
            if ($(this).is(':checked')) {
                $('input[name="tomada_220v[]"]').not(this).prop('checked', false);
            }
        });
    });
</script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        jQuery(document).ready(function($) {
            $('input[name=cpf]').mask('000.000.000-00');
            $('input[name=cnpj]').mask('00.000.000/0000-00');
            $('input[name=cep]').mask('00000-000');

            $('input[name=cep]').on('blur', function() {
                var cep = $(this).val().replace(/\D/g, '');
                if (cep.length === 8) {
                    $.getJSON('https://viacep.com.br/ws/' + cep + '/json/', function(data) {
                        if (!data.erro) {
                            $('input[name=endereco]').val(data.logradouro);
                            $('input[name=bairro]').val(data.bairro);
                            $('input[name=cidade]').val(data.localidade);
                            $('select[name=estado]').val(data.uf);
                        }
                    });
                }
            });
        });
    </script>
    <form class="cadastro-form" method="post" enctype="multipart/form-data">
        <?php echo $mensagem_sucesso ?: $mensagem_erro; ?>

        <label>Nome completo
        <input type="text" name="nome_completo" required></label>

        <label>CPF
        <input type="text" name="cpf"></label>

        <label>CNPJ
        <input type="text" name="cnpj"></label>

        <label>Data de nascimento
        <input type="date" name="data_nascimento"></label>

        <label>CEP
        <input type="text" name="cep"></label>

        <div class="row-group">
            <div>
                <label>Endereço
                <input type="text" name="endereco"></label>
            </div>
            <div style="max-width: 120px;">
                <label>Número
                <input type="text" name="numero"></label>
            </div>
        </div>

        <label>Complemento
        <input type="text" name="complemento"></label>

        <label>Bairro
        <input type="text" name="bairro"></label>

        <label>Cidade
        <input type="text" name="cidade"></label>

        <label>Estado
        <select name="estado">
            <option value="">Selecione</option>
            <?php
            foreach (['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'] as $uf) {
                echo "<option value='$uf'>$uf</option>";
            }
            ?>
        </select></label>

        <label>Alguns equipamentos do nosso portifólio usam voltagem 220v, você tem tomada nessa tensão disponível na sala que será instalado?</label>
        <div>
            <label class="checkbox-inline"><input type="checkbox" name="tomada_220v[]" value="Sim"> Sim</label>
            <label class="checkbox-inline"><input type="checkbox" name="tomada_220v[]" value="Não"> Não</label>
        </div>

        <label>Documento Frente
        <input type="file" name="documento_frente" accept=".jpg,.jpeg,.png,.pdf,.gif"></label>

        <label>Documento Verso
        <input type="file" name="documento_verso" accept=".jpg,.jpeg,.png,.pdf,.gif"></label>

        <button type="submit" name="cadastro_clientes_enviar">Enviar</button>
    </form>
    <?php

    return ob_get_clean();
});
